<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Trip extends Model 
{

    protected $table = 'trips';
    public $timestamps = true;
    protected $fillable = array('departure', 'trip_number');

    public function ticketAvailabilities()
    {
        return $this->hasMany('App\Models\TicketAvailability');
    }

    public function vessel()
    {
        return $this->belongsTo('App\Models\Vessel');
    }

    public function route()
    {
        return $this->belongsTo('App\Models\Route');
    }

}